/*Tabelle für Sonderfunktionen*/
CREATE TABLE settings
(
  s_vari                varchar(70) NOT null PRIMARY KEY,
  s_owner               varchar(50),  --ist bisher noch nicht verwendet und ist in den Funktionen nicht berücksichtigt
  s_inha                text,
  s_num_inha            numeric(20,8) -- Länge entspr. Standard für interne Werte
);

CREATE UNIQUE INDEX settings__s_vari_index ON settings( s_vari );
CREATE UNIQUE INDEX settings__s_vari_index__uq ON settings( upper( s_vari ) );


-- #21952 Abfangen von Duplikaten bzgl. Groß/Kleinschreibung
CREATE OR REPLACE FUNCTION settings__b_iu() RETURNS TRIGGER AS $$
BEGIN

  -- Groß/Kleinschreibungsduplikat updaten
  UPDATE settings SET s_inha = new.s_inha, s_num_inha = new.s_num_inha, s_owner = new.s_owner
  WHERE upper( s_vari ) = upper( new.s_vari );

  IF FOUND THEN
    -- Gab es ein Duplikat, dann ist alles mit dem Update oben erledigt.
    RETURN null;
  ELSE
    -- Kein Duplikat? Dann Vorgang normal fortsetzen.
    RETURN new;
  END IF;

END $$ LANGUAGE plpgsql;


CREATE TRIGGER settings__b_iu
  BEFORE INSERT OR UPDATE OF s_vari
  ON settings
  FOR EACH ROW
EXECUTE PROCEDURE settings__b_iu();
--

/*sprachschlüssel allgemein*/

CREATE TABLE sprach
 (spr_key               VARCHAR(5) NOT NULL PRIMARY KEY
 );

/*dokumentsprache für Anschreiben, referenziert die TextNr aus Text0,
  deshalb kann ein Sprachschlüssel verschiedene Textdateien haben*/


CREATE TABLE adkspco
 (s_spco                SERIAL PRIMARY KEY,
  s_spr_key             VARCHAR(5) NOT NULL REFERENCES sprach,
  s_sprach              INTEGER,       /*TEXT NR*/
  s_bb                  VARCHAR(75)     -- Hintergrund BriefBogen (FileName)
 );


 -- [SYNCRO-TABLE] Tabellen für Sprachen
-- ACHTUNG: Bei Änderungen die Felder im Cache TCimDM_SysDB.CimCacheDefinition:Text0 mit anpassen.
CREATE TABLE text0
 (t_nr                  integer PRIMARY KEY,   -- [SYNCRO:SyncID]
  t_feld0               text,                  -- [SYNCRO:Deleted='*DELETED*'] deutsch
  t_kundtxt0            text,                  -- [SYNCRO:NotThisFields] alternativer Kundentext
  t_feld0_modified      timestamp(0),
  t_feld1               text,                  -- französisch
  t_kundtxt1            text,                  -- [SYNCRO:NotThisFields]
  t_feld1_modified      timestamp(0),
  t_feld2               text,                  -- frei
  t_kundtxt2            text,                  -- [SYNCRO:NotThisFields]
  t_feld2_modified      timestamp(0),
  t_feld3               text,                  -- englisch
  t_kundtxt3            text,                  -- [SYNCRO:NotThisFields]
  t_feld3_modified      timestamp(0),
  t_feld4               text,                  -- italienisch
  t_kundtxt4            text,                  -- [SYNCRO:NotThisFields]
  t_feld4_modified      timestamp(0),
  t_feld5               text,                  -- spanisch
  t_kundtxt5            text,                  -- [SYNCRO:NotThisFields]
  t_feld5_modified      timestamp(0),
  t_feld6               text,                  -- tschechisch
  t_kundtxt6            text,                  -- [SYNCRO:NotThisFields]
  t_feld6_modified      timestamp(0),
  t_feld7               text,                  -- russisch
  t_kundtxt7            text,                  -- [SYNCRO:NotThisFields]
  t_feld7_modified      timestamp(0),
  t_feld8               text,                  -- frei
  t_kundtxt8            text,                  -- [SYNCRO:NotThisFields]
  t_feld8_modified      timestamp(0),
  --
  t_modified            timestamp(0)           -- [SYNCRO:Modified]
 );

CREATE INDEX text0_nr_group ON text0 (t_nr, t_feld0) WHERE t_feld0 LIKE 'TEXT0:%';  -- für Suche der Text0-Nummernbereiche "TEXT0:%"


-- Zeitstempel für Synchronisation setzen
CREATE OR REPLACE FUNCTION text0_modified() RETURNS TRIGGER AS $$
  DECLARE
    changed BOOL;
  BEGIN
    IF  NOT TSystem.current_user_in_syncro_dblink()  THEN
      changed := False;
      IF coalesce(new.t_feld0, '') <> coalesce(old.t_feld0, '') THEN  --deutsch

        -- HINWEIS DS: public. wegen FDW https://redmine.prodat-sql.de/issues/16893#note-32
        new.t_feld0_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld1, '') <> coalesce(old.t_feld1, '') THEN  --französisch
        new.t_feld1_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld2, '') <> coalesce(old.t_feld2, '') THEN  --frei
        new.t_feld2_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld3, '') <> coalesce(old.t_feld3, '') THEN  --englisch
        new.t_feld3_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld4, '') <> coalesce(old.t_feld4, '') THEN  --italienisch
        new.t_feld4_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld5, '') <> coalesce(old.t_feld5, '') THEN  --spanisch
        new.t_feld5_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld6, '') <> coalesce(old.t_feld6, '') THEN  --tschechisch
        new.t_feld6_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld7, '') <> coalesce(old.t_feld7, '') THEN  --russisch
        new.t_feld7_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld8, '') <> coalesce(old.t_feld8, '') THEN  --frei
        new.t_feld8_modified := public.currenttime();
        changed              := True;
      END IF;
      IF changed THEN
        new.t_modified       := public.currenttime();
        PERFORM TSystem.Settings__Set('textmodified', 'T');  -- Flag für TProdatSrvService.SendLokalChangedMail
      END IF;
    END IF;
    RETURN new;
  END$$ LANGUAGE plpgsql;

  CREATE TRIGGER text0_modified
    BEFORE UPDATE
    ON text0
    FOR EACH ROW
    EXECUTE PROCEDURE text0_modified();
--
/* Test für FUNCTION prodat_languages.reload_textx(txtno integer) => auch auskommentiert
CREATE TABLE textx_current(
  txc_nr      integer,
  txc_spco    integer,
  txc_text    varchar
  );

CREATE UNIQUE INDEX textx_current_pk ON textx_current(txc_nr, txc_spco) INCLUDE(txc_text);
*/

-- Infos zu allen Texten für die Synchronisation
CREATE OR REPLACE FUNCTION text0_GetSync(tnr integer) RETURNS text AS $$
  BEGIN
    RETURN
         E'***** deutsch '     || coalesce(t_feld0_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld0, '') || E'\n\n'
      || E'***** französisch ' || coalesce(t_feld1_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld1, '') || E'\n\n'
      || E'***** frei '        || coalesce(t_feld2_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld2, '') || E'\n\n'
      || E'***** englisch '    || coalesce(t_feld3_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld3, '') || E'\n\n'
      || E'***** italienisch ' || coalesce(t_feld4_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld4, '') || E'\n\n'
      || E'***** spanisch '    || coalesce(t_feld5_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld5, '') || E'\n\n'
      || E'***** tschechisch ' || coalesce(t_feld6_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld6, '') || E'\n\n'
      || E'***** russisch '    || coalesce(t_feld7_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld7, '') || E'\n\n'
      || E'***** frei '        || coalesce(t_feld8_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld8, '')
    FROM text0
    WHERE t_nr = tnr;
  END$$ LANGUAGE plpgsql;
--

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- DBLOG
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- table to store csvlogfilenames, which are already imported
--   1) check dblog.csvlogfiles for entries which exist no longer and delete from dblog.csvlogfiles
--   2) check dblog.csvlogfiles for files which are still on disk and delete those file
--   3) import file + add to dblog.csvlogfiles
CREATE TABLE IF NOT EXISTS tlog.dblogfiles_imported
(
  dblfi_date     date NOT NULL,
  dblfi_database varchar NOT NULL,
  dblfi_pid      integer NOT NULL,
  dblfi_txid     varchar DEFAULT pg_current_xact_id_if_assigned(),
  dblfi_time     integer NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_dblogfiles_imported_primary ON tlog.dblogfiles_imported(dblfi_date, dblfi_time, dblfi_database, dblfi_pid, dblfi_txid);

--------------------------------------------------------------------------------
CREATE SEQUENCE IF NOT EXISTS tlog.dblog_id;
CREATE TABLE IF NOT EXISTS tlog.dblog
(
  dbl_id                   bigint  PRIMARY KEY NOT NULL DEFAULT nextval('tlog.dblog_id'::regclass),
  dbl_ts_tx                timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, current_timestamp), -- current_timestamp => start time of the current transaction
  dbl_ts_stmt              timestamp without time zone NOT NULL DEFAULT timezone('utc'::text, clock_timestamp()), -- clock_timestamp => actual high precision time of statement/logentry
  dbl_type                 tlog.dblog_logtype   NOT NULL,
  dbl_level                tlog.dblog_loglevel  NOT NULL,
  dbl_source               tlog.dblog_logsource NOT NULL,
  dbl_conn_suser           varchar NOT NULL DEFAULT session_user, -- NO brackets !!!
  dbl_conn_cuser           varchar NOT NULL DEFAULT current_user, -- NO brackets !!!
  dbl_conn_ip              inet    NOT NULL DEFAULT inet_client_addr(),
  dbl_conn_pid             integer NOT NULL DEFAULT pg_backend_pid(),
  dbl_conn_application     varchar NOT NULL DEFAULT current_setting('application_name'),
  dbl_txid                 varchar DEFAULT pg_current_xact_id_if_assigned(), -- pg_current_xact_id_if_assigned() only with PG 10 upwards
  dbl_txid_snapshot        varchar DEFAULT pg_current_snapshot(),
  dbl_parent_id            bigint,
  dbl_func_name            varchar,
  dbl_ctx                  varchar,
  dbl_msg                  varchar
);

COMMENT ON COLUMN tlog.dblog.dbl_id               IS 'unique id (within database)';
COMMENT ON COLUMN tlog.dblog.dbl_ts_tx            IS 'timestamp of transaction';
COMMENT ON COLUMN tlog.dblog.dbl_ts_stmt          IS 'high precision timestamp of statement/logentry';
COMMENT ON COLUMN tlog.dblog.dbl_type             IS 'different groups of logging, nonspecific to context';
COMMENT ON COLUMN tlog.dblog.dbl_level            IS 'loglevel as known from delphi code';
COMMENT ON COLUMN tlog.dblog.dbl_source           IS 'client or db (implicit called stuff)';
COMMENT ON COLUMN tlog.dblog.dbl_conn_suser       IS 'role that initiated the connection (session) (or changed to via SET SESSION AUTHORIZATION)';
COMMENT ON COLUMN tlog.dblog.dbl_conn_cuser       IS 'current role (SET ROLE)';
COMMENT ON COLUMN tlog.dblog.dbl_conn_ip          IS 'ip of the initiated connection';
COMMENT ON COLUMN tlog.dblog.dbl_conn_pid         IS 'pid of the postgres process';
COMMENT ON COLUMN tlog.dblog.dbl_conn_application IS 'application string of the initiated connection';
COMMENT ON COLUMN tlog.dblog.dbl_txid             IS 'transaction id';
COMMENT ON COLUMN tlog.dblog.dbl_txid_snapshot    IS 'snapshot id within tx';
COMMENT ON COLUMN tlog.dblog.dbl_parent_id        IS 'parent logid, to make trees';
COMMENT ON COLUMN tlog.dblog.dbl_func_name        IS 'name of function which made the log entry';
COMMENT ON COLUMN tlog.dblog.dbl_ctx              IS 'context';
COMMENT ON COLUMN tlog.dblog.dbl_msg              IS 'message';

CREATE INDEX dblog__dbl_ts_tx ON tlog.dblog (dbl_ts_tx);  -- DROP INDEX tlog.dblog__dbl_ts_tx;
CREATE INDEX dblog__dbl_type  ON tlog.dblog (dbl_type);
CREATE INDEX dblog__dbl_level ON tlog.dblog (dbl_level);
CREATE INDEX dblog__dbl_source ON tlog.dblog (dbl_source);

-- Für ausrechnen von Search-Vector (siehe CREATE INDEX idx_dblog_search_vector)
CREATE OR REPLACE FUNCTION tlog.tsvector(_dblog tlog.dblog) RETURNS tsvector AS $$
BEGIN
  RETURN to_tsvector(coalesce(_dblog.dbl_func_name, '') || ' ' ||
                              _dblog.dbl_source::text   || ' ' ||
                              _dblog.dbl_conn_suser     || ' ' ||
                     coalesce(_dblog.dbl_msg, '')
                    );
END;
$$ LANGUAGE plpgsql IMMUTABLE;

CREATE INDEX idx_dblog_search_vector ON tlog.dblog USING GIN (tlog.tsvector(dblog)); --DROP INDEX tlog.idx_dblog_search_vector;
